/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer;

import bre.fpsreducer.FpsReducerConfig;
import bre.fpsreducer.WakeupEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OverlayEventHandler {
    Minecraft mc = Minecraft.func_71410_x();
    FontRenderer fontRenderer;
    int fpsCounter = 0;
    int debugFPS = 0;
    long nextUpdateTime = 0L;
    int marginX;
    int marginY;
    int hudColor;

    public OverlayEventHandler() {
        this.fontRenderer = this.mc.field_71466_p;
        this.marginX = FpsReducerConfig.hudMarginX;
        this.marginY = FpsReducerConfig.hudMarginY;
        this.hudColor = FpsReducerConfig.hudColorRed << 16 | FpsReducerConfig.hudColorGreen << 8 | FpsReducerConfig.hudColorBlue;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (FpsReducerConfig.hudLocation == 0) {
            return;
        }
        ++this.fpsCounter;
        if (System.currentTimeMillis() >= this.nextUpdateTime) {
            this.debugFPS = this.fpsCounter;
            this.fpsCounter = 0;
            this.nextUpdateTime = System.currentTimeMillis() + 1000L;
        }
        if (!this.mc.field_71474_y.field_74330_P) {
            int posY;
            int posX;
            String fpsStr = WakeupEventHandler.reduceFPS ? "\u00a7aECO MODE: " + this.debugFPS + "\u00a7r" : "FPS: " + this.debugFPS;
            switch (FpsReducerConfig.hudLocation) {
                case 1: {
                    posX = this.marginX;
                    posY = this.marginY;
                    break;
                }
                case 2: {
                    posX = event.getResolution().func_78326_a() - this.fontRenderer.func_78256_a(fpsStr) - this.marginX;
                    posY = this.marginY;
                    break;
                }
                case 3: {
                    posX = event.getResolution().func_78326_a() - this.fontRenderer.func_78256_a(fpsStr) - this.marginX;
                    posY = event.getResolution().func_78328_b() - 8 - this.marginY;
                    break;
                }
                case 4: {
                    posX = this.marginX;
                    posY = event.getResolution().func_78328_b() - 8 - this.marginY;
                    break;
                }
                default: {
                    posX = this.marginX;
                    posY = this.marginY;
                }
            }
            this.fontRenderer.func_175063_a(fpsStr, (float)posX, (float)posY, this.hudColor);
        }
    }
}

